<?php
/**
 * Plugin Name: JadCoins - WooCommerce Loyalty Integration
 * Plugin URI: https://jadcoins.online
 * Description: Integrate JadCoins loyalty & wallet system with your WooCommerce store. Earn points on purchases, redeem wallet balance at checkout.
 * Version: 2.0.0
 * Author: JadCoins
 * Author URI: https://jadcoins.online
 * Text Domain: jadcoins-woo
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * WC requires at least: 5.0
 * WC tested up to: 9.0
 * License: GPL-2.0+
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'JADCOINS_WOO_VERSION', '2.0.0' );
define( 'JADCOINS_WOO_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'JADCOINS_WOO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'JADCOINS_WOO_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

function jadcoins_woo_check_woocommerce() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', function () {
            echo '<div class="error"><p>';
            esc_html_e( 'JadCoins WooCommerce Integration requires WooCommerce to be installed and active.', 'jadcoins-woo' );
            echo '</p></div>';
        } );
        return false;
    }
    return true;
}

function jadcoins_woo_init() {
    if ( ! jadcoins_woo_check_woocommerce() ) {
        return;
    }

    load_plugin_textdomain( 'jadcoins-woo', false, dirname( JADCOINS_WOO_PLUGIN_BASENAME ) . '/languages' );

    require_once JADCOINS_WOO_PLUGIN_DIR . 'includes/class-jadcoins-api.php';
    require_once JADCOINS_WOO_PLUGIN_DIR . 'includes/class-jadcoins-admin.php';
    require_once JADCOINS_WOO_PLUGIN_DIR . 'includes/class-jadcoins-checkout.php';
    require_once JADCOINS_WOO_PLUGIN_DIR . 'includes/class-jadcoins-account.php';
    require_once JADCOINS_WOO_PLUGIN_DIR . 'includes/class-jadcoins-orders.php';
    require_once JADCOINS_WOO_PLUGIN_DIR . 'includes/class-jadcoins-product.php';
    require_once JADCOINS_WOO_PLUGIN_DIR . 'includes/class-jadcoins-i18n.php';

    JadCoins_API::instance();
    JadCoins_Admin::instance();
    JadCoins_Checkout::instance();
    JadCoins_Account::instance();
    JadCoins_Orders::instance();
    JadCoins_Product::instance();
    JadCoins_i18n::instance();
}
add_action( 'plugins_loaded', 'jadcoins_woo_init' );

function jadcoins_woo_activate() {
    if ( ! get_option( 'jadcoins_api_url' ) ) {
        update_option( 'jadcoins_api_url', 'https://jadcoins.online/api' );
    }
    // Schedule a flush for after init
    update_option( 'jadcoins_flush_rewrite', 'yes' );
}
register_activation_hook( __FILE__, 'jadcoins_woo_activate' );

// Flush rewrite rules after endpoint is registered
add_action( 'init', function() {
    // Flush on activation
    if ( get_option( 'jadcoins_flush_rewrite' ) === 'yes' ) {
        delete_option( 'jadcoins_flush_rewrite' );
        // Re-register endpoint before flushing
        add_rewrite_endpoint( 'jadcoins', EP_ROOT | EP_PAGES );
        flush_rewrite_rules();
    }
    // Flush on version update
    $stored_version = get_option( 'jadcoins_woo_version', '' );
    if ( $stored_version !== JADCOINS_WOO_VERSION ) {
        update_option( 'jadcoins_woo_version', JADCOINS_WOO_VERSION );
        add_rewrite_endpoint( 'jadcoins', EP_ROOT | EP_PAGES );
        flush_rewrite_rules();
    }
}, 999 );

function jadcoins_woo_deactivate() {
    flush_rewrite_rules();
}
register_deactivation_hook( __FILE__, 'jadcoins_woo_deactivate' );

add_filter( 'plugin_action_links_' . JADCOINS_WOO_PLUGIN_BASENAME, function ( $links ) {
    $settings_link = '<a href="' . admin_url( 'admin.php?page=jadcoins-settings' ) . '">' . __( 'Settings', 'jadcoins-woo' ) . '</a>';
    array_unshift( $links, $settings_link );
    return $links;
} );

add_action( 'before_woocommerce_init', function () {
    if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
    }
} );
