<?php
/**
 * JadCoins i18n - Translation Handler
 * Supports: English, Arabic (ar), Hebrew (he_IL)
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class JadCoins_i18n {

    private static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        // Override translations using PHP filter (no .mo files needed)
        add_filter( 'gettext', array( $this, 'translate_strings' ), 10, 3 );
        add_filter( 'ngettext', array( $this, 'translate_nstrings' ), 10, 5 );
    }

    /**
     * Get current language code
     */
    private function get_lang() {
        $locale = determine_locale();

        if ( strpos( $locale, 'ar' ) === 0 ) {
            return 'ar';
        }
        if ( strpos( $locale, 'he' ) === 0 ) {
            return 'he';
        }
        return 'en';
    }

    /**
     * Translate strings filter
     */
    public function translate_strings( $translated, $original, $domain ) {
        if ( $domain !== 'jadcoins-woo' ) {
            return $translated;
        }

        $lang = $this->get_lang();
        if ( $lang === 'en' ) {
            return $translated;
        }

        $translations = $this->get_translations( $lang );
        return $translations[ $original ] ?? $translated;
    }

    /**
     * Translate plural strings
     */
    public function translate_nstrings( $translated, $single, $plural, $number, $domain ) {
        if ( $domain !== 'jadcoins-woo' ) {
            return $translated;
        }
        $lang = $this->get_lang();
        if ( $lang === 'en' ) {
            return $translated;
        }
        $translations = $this->get_translations( $lang );
        $key = ( $number == 1 ) ? $single : $plural;
        return $translations[ $key ] ?? $translated;
    }

    /**
     * Get translations for a language
     */
    private function get_translations( $lang ) {
        static $cache = array();
        if ( isset( $cache[ $lang ] ) ) {
            return $cache[ $lang ];
        }

        if ( $lang === 'ar' ) {
            $cache['ar'] = $this->arabic_translations();
        } elseif ( $lang === 'he' ) {
            $cache['he'] = $this->hebrew_translations();
        } else {
            $cache[ $lang ] = array();
        }

        return $cache[ $lang ];
    }

    private function arabic_translations() {
        return array(
            // Admin
            'JadCoins'                                                          => 'جاد كوينز',
            'JadCoins Settings'                                                 => 'إعدادات جاد كوينز',
            'API Connection'                                                    => 'اتصال API',
            'API URL'                                                           => 'رابط API',
            'Company Unique Code'                                               => 'كود الشركة',
            'Your company unique code from JadCoins dashboard.'                 => 'كود شركتك من لوحة تحكم جاد كوينز.',
            'Default Phone Code'                                                => 'رمز الهاتف الافتراضي',
            'Connect & Verify'                                                  => 'ربط والتحقق',
            'Testing connection...'                                             => 'جاري فحص الاتصال...',
            'Connection successful!'                                            => 'تم الاتصال بنجاح!',
            'Connection failed:'                                                => 'فشل الاتصال:',
            'Connected'                                                         => 'متصل',
            'Since %s'                                                          => 'منذ %s',
            'Code:'                                                             => 'الكود:',
            'API:'                                                              => 'الرابط:',
            'Points:'                                                           => 'النقاط:',
            'Disconnect'                                                        => 'قطع الاتصال',
            'Disconnect to change API settings'                                 => 'اقطع الاتصال لتغيير إعدادات API',
            'Are you sure you want to disconnect from JadCoins? This will remove the connection and you will need to reconnect.' => 'هل أنت متأكد من قطع الاتصال بجاد كوينز؟ ستحتاج لإعادة الربط.',
            'Disconnected successfully. You can now change settings.'           => 'تم قطع الاتصال بنجاح. يمكنك الآن تعديل الإعدادات.',
            'Please fill in API URL and Company Code.'                          => 'يرجى تعبئة رابط API وكود الشركة.',

            // Loyalty Settings
            'Loyalty Settings'                                                  => 'إعدادات الولاء',
            'Enable Points Earning'                                             => 'تفعيل كسب النقاط',
            'Award points to customers when orders are completed'               => 'منح نقاط للزبائن عند اكتمال الطلب',
            'Enable Wallet Payment'                                             => 'تفعيل الدفع بالمحفظة',
            'Allow customers to use wallet balance at checkout'                 => 'السماح للزبائن باستخدام رصيد المحفظة عند الدفع',
            'Earn Points On Status'                                             => 'كسب نقاط عند حالة',
            'Completed'                                                         => 'مكتمل',
            'Processing'                                                        => 'قيد المعالجة',

            // Display Settings
            'Display Settings'                                                  => 'إعدادات العرض',
            'Show in My Account'                                                => 'عرض في حسابي',
            'Show JadCoins balance tab in My Account page'                      => 'عرض تبويب رصيد جاد كوينز في صفحة حسابي',
            'Show Points on Product Page'                                       => 'عرض النقاط بصفحة المنتج',
            'Display how many points the customer will earn on product pages'   => 'عرض عدد النقاط التي سيكسبها الزبون بصفحة المنتج',
            'Show Points in Cart'                                               => 'عرض النقاط بالسلة',
            'Display total points the customer will earn from their cart'       => 'عرض إجمالي النقاط التي سيكسبها الزبون من السلة',
            'Save Settings'                                                     => 'حفظ الإعدادات',
            'Settings'                                                          => 'الإعدادات',

            // Product & Cart
            'Earn %s points with this purchase!'                                => 'اكسب %s نقطة مع هذا الشراء!',
            'Earn %s points'                                                        => 'اكسب %s نقطة',
            'You will earn %s points with this order!'                              => 'ستكسب %s نقطة مع هذا الطلب!',
            'JadCoins Points'                                                   => '',
            'points'                                                            => 'نقاط',

            // Checkout
            'JadCoins Wallet'                                                   => 'محفظة جاد كوينز',
            'Loading your balance...'                                           => 'جاري تحميل رصيدك...',
            'Points Balance:'                                                   => 'رصيد النقاط:',
            'Wallet Balance:'                                                   => 'رصيد المحفظة:',
            'Amount to use'                                                     => 'المبلغ المراد استخدامه',
            'Apply'                                                             => 'تطبيق',
            'Remove'                                                            => 'إزالة',
            'Wallet discount applied!'                                          => 'تم تطبيق خصم المحفظة!',
            'Wallet discount removed.'                                          => 'تم إزالة خصم المحفظة.',
            'Something went wrong. Please try again.'                           => 'حدث خطأ. يرجى المحاولة مرة أخرى.',
            'No wallet balance available.'                                      => 'لا يوجد رصيد في المحفظة.',
            'Enter amount to use'                                               => 'أدخل المبلغ',
            'Amount exceeds your wallet balance.'                               => 'المبلغ يتجاوز رصيد محفظتك.',
            'JadCoins Wallet Discount'                                          => 'خصم محفظة جاد كوينز',
            'Wallet discount:'                                                  => 'خصم المحفظة:',
            'Loading...'                                                        => 'جاري التحميل...',

            // Account
            'My JadCoins'                                                       => 'جاد كوينز الخاصة بي',
            'Points Balance'                                                    => 'رصيد النقاط',
            'Wallet Balance'                                                    => 'رصيد المحفظة',
            'Worth %1$s%2$s'                                                    => 'بقيمة %1$s%2$s',
            'Available at checkout'                                             => 'متاح عند الدفع',
            'How It Works'                                                      => 'كيف يعمل',
            'Earn %s%% points on every purchase'                                => 'اكسب %s%% نقاط على كل عملية شراء',
            'Earn %s points on every purchase'                                  => 'اكسب %s نقاط على كل عملية شراء',
            'Every %1$s points = %2$s in your wallet'                           => 'كل %1$s نقاط = %2$s في محفظتك',
            'Use your wallet balance at checkout for discounts!'                => 'استخدم رصيد محفظتك عند الدفع للحصول على خصومات!',
            'Phone Country Code'                                                => 'رمز الدولة للهاتف',
            'Birthday'                                                          => 'تاريخ الميلاد',
            'Loyalty program is not currently available.'                       => 'برنامج الولاء غير متاح حالياً.',
            'Please add your phone number in your billing details to view your JadCoins balance.' => 'يرجى إضافة رقم هاتفك في بيانات الفوترة لعرض رصيد جاد كوينز.',
            'Could not retrieve your JadCoins information. Please try again later.' => 'لم نتمكن من استرجاع بيانات جاد كوينز. يرجى المحاولة لاحقاً.',

            // Orders
            'Wallet Used:'                                                      => 'محفظة مستخدمة:',
            'Points Earned:'                                                    => 'نقاط مكتسبة:',
            'JadCoins Loyalty'                                                  => 'ولاء جاد كوينز',
            'No JadCoins activity for this order.'                              => 'لا يوجد نشاط جاد كوينز لهذا الطلب.',
            'Points not yet earned (order not completed)'                       => 'لم يتم كسب النقاط بعد (الطلب لم يكتمل)',

            // WooCommerce
            'JadCoins WooCommerce Integration requires WooCommerce to be installed and active.' => 'تكامل جاد كوينز مع ووكومرس يتطلب تنصيب وتفعيل ووكومرس.',
        );
    }

    private function hebrew_translations() {
        return array(
            // Admin
            'JadCoins'                                                          => 'ג\'אד קוינז',
            'JadCoins Settings'                                                 => 'הגדרות ג\'אד קוינז',
            'API Connection'                                                    => 'חיבור API',
            'API URL'                                                           => 'כתובת API',
            'Company Unique Code'                                               => 'קוד חברה',
            'Your company unique code from JadCoins dashboard.'                 => 'קוד החברה שלך מלוח הבקרה של ג\'אד קוינז.',
            'Default Phone Code'                                                => 'קידומת טלפון',
            'Connect & Verify'                                                  => 'חבר ואמת',
            'Testing connection...'                                             => 'בודק חיבור...',
            'Connection successful!'                                            => 'החיבור הצליח!',
            'Connection failed:'                                                => 'החיבור נכשל:',
            'Connected'                                                         => 'מחובר',
            'Since %s'                                                          => 'מאז %s',
            'Code:'                                                             => 'קוד:',
            'API:'                                                              => 'API:',
            'Points:'                                                           => 'נקודות:',
            'Disconnect'                                                        => 'נתק',
            'Disconnect to change API settings'                                 => 'נתק כדי לשנות הגדרות API',
            'Are you sure you want to disconnect from JadCoins? This will remove the connection and you will need to reconnect.' => 'האם אתה בטוח שברצונך להתנתק מג\'אד קוינז? תצטרך להתחבר מחדש.',
            'Disconnected successfully. You can now change settings.'           => 'נותק בהצלחה. כעת תוכל לשנות הגדרות.',
            'Please fill in API URL and Company Code.'                          => 'נא למלא כתובת API וקוד חברה.',

            'Loyalty Settings'                                                  => 'הגדרות נאמנות',
            'Enable Points Earning'                                             => 'הפעלת צבירת נקודות',
            'Award points to customers when orders are completed'               => 'הענקת נקודות כאשר הזמנה הושלמה',
            'Enable Wallet Payment'                                             => 'הפעלת תשלום מארנק',
            'Allow customers to use wallet balance at checkout'                 => 'אפשר שימוש ביתרת ארנק בתשלום',
            'Earn Points On Status'                                             => 'צבירת נקודות בסטטוס',
            'Completed'                                                         => 'הושלם',
            'Processing'                                                        => 'בעיבוד',

            'Display Settings'                                                  => 'הגדרות תצוגה',
            'Show in My Account'                                                => 'הצג בחשבון שלי',
            'Show JadCoins balance tab in My Account page'                      => 'הצג לשונית יתרה בדף חשבון שלי',
            'Show Points on Product Page'                                       => 'הצג נקודות בדף מוצר',
            'Display how many points the customer will earn on product pages'   => 'הצג כמה נקודות הלקוח יצבור בדף מוצר',
            'Show Points in Cart'                                               => 'הצג נקודות בעגלה',
            'Display total points the customer will earn from their cart'       => 'הצג סה"כ נקודות שהלקוח יצבור מהעגלה',
            'Save Settings'                                                     => 'שמור הגדרות',
            'Settings'                                                          => 'הגדרות',

            'Earn %s points with this purchase!'                                => 'צבור %s נקודות עם רכישה זו!',
            'Earn %s points'                                                        => 'צבור %s נקודות',
            'You will earn %s points with this order!'                              => 'תצבור %s נקודות עם הזמנה זו!',
            'JadCoins Points'                                                   => 'נקודות ג\'אד קוינז',
            'points'                                                            => 'נקודות',

            'JadCoins Wallet'                                                   => 'ארנק ג\'אד קוינז',
            'Loading your balance...'                                           => 'טוען יתרה...',
            'Points Balance:'                                                   => 'יתרת נקודות:',
            'Wallet Balance:'                                                   => 'יתרת ארנק:',
            'Amount to use'                                                     => 'סכום לשימוש',
            'Apply'                                                             => 'החל',
            'Remove'                                                            => 'הסר',
            'Wallet discount applied!'                                          => 'הנחת ארנק הוחלה!',
            'Wallet discount removed.'                                          => 'הנחת ארנק הוסרה.',
            'Something went wrong. Please try again.'                           => 'משהו השתבש. נסה שוב.',
            'No wallet balance available.'                                      => 'אין יתרה בארנק.',
            'Enter amount to use'                                               => 'הזן סכום',
            'Amount exceeds your wallet balance.'                               => 'הסכום עולה על יתרת הארנק.',
            'JadCoins Wallet Discount'                                          => 'הנחת ארנק ג\'אד קוינז',
            'Wallet discount:'                                                  => 'הנחת ארנק:',
            'Loading...'                                                        => 'טוען...',

            'My JadCoins'                                                       => 'הג\'אד קוינז שלי',
            'Points Balance'                                                    => 'יתרת נקודות',
            'Wallet Balance'                                                    => 'יתרת ארנק',
            'Available at checkout'                                             => 'זמין בתשלום',
            'How It Works'                                                      => 'איך זה עובד',
            'Use your wallet balance at checkout for discounts!'                => 'השתמש ביתרת הארנק בתשלום לקבלת הנחות!',
            'Phone Country Code'                                                => 'קידומת מדינה',
            'Birthday'                                                          => 'תאריך לידה',
            'Loyalty program is not currently available.'                       => 'תוכנית הנאמנות אינה זמינה כרגע.',
            'Please add your phone number in your billing details to view your JadCoins balance.' => 'הוסף מספר טלפון בפרטי חיוב כדי לצפות ביתרה.',
            'Could not retrieve your JadCoins information. Please try again later.' => 'לא ניתן לאחזר נתונים. נסה שוב.',

            'Wallet Used:'                                                      => 'ארנק ששימש:',
            'Points Earned:'                                                    => 'נקודות שנצברו:',
            'JadCoins Loyalty'                                                  => 'נאמנות ג\'אד קוינז',
            'No JadCoins activity for this order.'                              => 'אין פעילות להזמנה זו.',
            'Points not yet earned (order not completed)'                       => 'נקודות טרם נצברו (הזמנה לא הושלמה)',
        );
    }
}
