# JadCoins WooCommerce Plugin - Documentation

## Complete Setup & Usage Guide for WordPress Store Owners

**Version:** 2.0.0
**Last Updated:** February 2026

---

## Table of Contents

1. What is JadCoins?
2. Installation
3. Initial Setup & Connection
4. Settings Configuration
5. How Points Work
6. How the Wallet Works
7. Customer Experience
8. Admin Order Management
9. Multilingual Support
10. Troubleshooting
11. FAQ

---

## 1. What is JadCoins?

JadCoins is a loyalty and rewards system that integrates with your WooCommerce store. It allows your customers to earn points on every purchase, accumulate wallet balance, and use that balance as a discount on future purchases.

**Key Features:**

- Automatic points earning on every order
- Wallet balance that can be used at checkout
- Points display on product pages and in cart
- Customer balance dashboard in My Account
- Birthday collection for loyalty programs
- Multilingual support (English, Arabic, Hebrew)
- Secure connection management

---

## 2. Installation

### Method 1: Upload via WordPress Admin

1. Go to **Plugins → Add New → Upload Plugin**
2. Choose the `jadcoins-woocommerce.zip` file
3. Click **Install Now**
4. After installation, click **Activate Plugin**

### Method 2: FTP Upload

1. Extract the ZIP file
2. Upload the `jadcoins-woocommerce` folder to `/wp-content/plugins/`
3. Go to **Plugins** in WordPress admin
4. Find "JadCoins - WooCommerce Loyalty Integration" and click **Activate**

### Requirements

- WordPress 5.8 or higher
- PHP 7.4 or higher
- WooCommerce 5.0 or higher
- Active JadCoins account with a Company Unique Code

---

## 3. Initial Setup & Connection

### Step 1: Open JadCoins Settings

After activation, you'll see a new **JadCoins** menu item (with a star icon) in your WordPress admin sidebar. Click on it.

### Step 2: Enter Connection Details

- **API URL:** Leave as default (`https://jadcoins.online/api`) unless instructed otherwise
- **Company Unique Code:** Enter the unique code from your JadCoins dashboard
- **Default Phone Code:** Enter your country's phone code (e.g., `+972` for Israel)

### Step 3: Connect & Verify

Click the **Connect & Verify** button. The plugin will test the connection and display your company information including:

- Company name
- Loyalty status (enabled/disabled)
- Points configuration
- Currency settings

### Step 4: Connection Lock

Once connected successfully, the connection is **locked**. This means:

- The API URL and Company Code fields become read-only
- A green "Connected" badge is displayed
- Connection details are shown for reference
- To change settings, you must first **Disconnect**

### Disconnecting

If you need to change your API settings:

1. Click the **Disconnect** button
2. Confirm the action in the popup dialog
3. The connection fields become editable again
4. Enter new details and click **Connect & Verify**

> **Security Note:** The lock mechanism prevents accidental changes to your integration settings. Always verify your new settings before reconnecting.

---

## 4. Settings Configuration

### Loyalty Settings

| Setting | Description | Default |
|---------|-------------|---------|
| **Enable Points Earning** | When ON, customers earn points on orders | ON |
| **Enable Wallet Payment** | When ON, customers can use wallet at checkout | ON |
| **Earn Points On Status** | When should points be awarded: "Completed" or "Processing" | Completed |

**Recommended:** Keep "Earn Points On Status" set to **Completed** for physical products (to avoid awarding points for cancelled orders). Use **Processing** only for digital products.

### Display Settings

| Setting | Description | Default |
|---------|-------------|---------|
| **Show in My Account** | Display JadCoins balance tab in customer's account | ON |
| **Show Points on Product Page** | Show estimated points on each product page | ON |
| **Show Points in Cart** | Show total earned points in cart summary | ON |

---

## 5. How Points Work

### Earning Points

Points are calculated on the **order total after tax, excluding shipping costs**.

**Formula Example:**
- Product subtotal: ₪100
- Tax (17%): ₪17
- Shipping: ₪20
- **Amount used for points: ₪117** (subtotal + tax, no shipping)

If your JadCoins settings are 10% points, the customer earns **11 points** on this order.

### Points Display

When enabled, customers see:

- **Product Page:** "⭐ Earn **11** points with this purchase!" (based on product price with tax)
- **Cart Page:** A row showing "+11 points" next to the order total
- **Checkout Page:** Same as cart, plus wallet option if they have balance

### Auto-Redemption

JadCoins may automatically convert points to wallet balance based on your loyalty settings. For example, if your minimum redemption is 10 points and point value is ₪10, when a customer reaches 10 points, they automatically get ₪100 in their wallet.

---

## 6. How the Wallet Works

### Wallet Balance

The wallet is a monetary balance stored in the customer's JadCoins account. It's funded by:

- Auto-redeemed points
- Manual additions via JadCoins dashboard
- Promotions or bonuses

### Using Wallet at Checkout

1. Customer proceeds to checkout
2. If logged in and has wallet balance, a **JadCoins Wallet** section appears
3. Shows current points balance and wallet balance
4. Customer enters the amount they want to use (up to their wallet balance)
5. Clicks **Apply** to get a discount
6. The discount appears as "JadCoins Wallet Discount" in the order summary
7. Customer can click **Remove** to cancel the wallet discount

### Validation Rules

- Wallet amount cannot exceed wallet balance
- Wallet amount cannot exceed cart total
- Wallet balance is verified in real-time before applying
- Guest (non-logged-in) customers cannot use wallet at checkout

---

## 7. Customer Experience

### Registration & Sync

When a customer registers or updates their profile, the plugin automatically:

1. Sends their information to JadCoins (name, email, phone, birthday)
2. Creates a JadCoins customer account if one doesn't exist
3. Links the WooCommerce account with JadCoins via phone number

### My Account - JadCoins Tab

Customers see a dedicated **JadCoins** tab in their account with:

- **Points Balance** card showing current points
- **Wallet Balance** card showing available credit
- **How It Works** section explaining the loyalty program

### Birthday Collection

The plugin collects customer birthdays through:

- My Account → Edit Account (birthday date field)
- Checkout billing form (birthday field)

Birthdays are sent to JadCoins for birthday promotions and rewards.

### Phone Number

The customer's phone number is the primary identifier for JadCoins. Make sure customers have their billing phone number saved. The plugin also adds a "Phone Country Code" field (default: +972).

---

## 8. Admin Order Management

### Order Notes

Every JadCoins action is logged as an order note:

- **Points earned:** "JadCoins: 11 points earned (on ₪117.00). New balance: 11. TXN: 283"
- **Auto-redeemed:** "JadCoins: Auto-redeemed 10 points → 100 added to wallet."
- **Wallet used:** "JadCoins wallet: ₪50.00 deducted. Transaction ID: 102"
- **Errors:** "JadCoins: Failed to earn points - [error message]"

### JadCoins Loyalty Meta Box

In the order edit page sidebar, you'll find a **JadCoins Loyalty** meta box showing:

- ✅ Wallet Used: amount and transaction ID
- ✅ Points Earned: count and calculated amount
- ⏳ Pending states for unprocessed orders

### Duplicate Protection

The plugin prevents double-processing:

- Points are only earned once per order (tracked via `_jadcoins_points_processed` meta)
- Wallet deductions are only processed once (tracked via `_jadcoins_wallet_processed` meta)

---

## 9. Multilingual Support

The plugin supports three languages:

| Language | Locale | Direction |
|----------|--------|-----------|
| English | en_US | LTR |
| Arabic | ar | RTL |
| Hebrew | he_IL | RTL |

### How It Works

Translations are built into the plugin. The language is automatically detected based on your WordPress site language setting.

To change language: **Settings → General → Site Language**

The plugin's CSS includes RTL support for right-to-left languages.

---

## 10. Troubleshooting

### "Connection Failed" Error

1. **Check API URL:** Should be `https://jadcoins.online/api` (with `/api`)
2. **Check Company Code:** Must match exactly (case-sensitive)
3. **Check server:** Your hosting must allow outgoing HTTPS connections

### JadCoins Tab Shows 404

Go to **Settings → Permalinks** and click **Save Changes** (this refreshes URL rules).

### Points Not Being Earned

1. Check if **Enable Points Earning** is ON in settings
2. Verify the order reached the configured status (Completed/Processing)
3. Check order notes for error messages
4. Verify the customer has a phone number saved

### Wallet Not Showing at Checkout

1. Check if **Enable Wallet Payment** is ON
2. Customer must be logged in
3. Customer must have a phone number in billing details
4. Customer must have wallet balance > 0

### Birthday Not Saving

1. Birthday field appears in My Account → Edit Account
2. Also appears in checkout billing form
3. Birthday is sent on next sync (account save or new order)

### Translations Not Working

1. Check your WordPress language is set to Arabic or Hebrew
2. If using WPML or Polylang, ensure the locale matches (ar, he_IL)
3. Clear any caching plugins after language change

---

## 11. FAQ

**Q: Do guest customers earn points?**
A: Yes! When a guest order is completed, points are awarded using the billing phone number. However, guests cannot use wallet at checkout.

**Q: Can I change the points calculation?**
A: Points configuration (percentage, fixed, point value) is managed in your JadCoins dashboard, not in the WordPress plugin.

**Q: Is the plugin compatible with WooCommerce HPOS?**
A: Yes, the plugin declares compatibility with WooCommerce High-Performance Order Storage.

**Q: Can I use this with multiple WooCommerce stores?**
A: Yes, each store connects with the same company code. Customer accounts are unified via phone number.

**Q: How do I give a customer extra points/wallet?**
A: Use the JadCoins dashboard directly. Changes reflect in WooCommerce automatically.

**Q: What happens if the JadCoins API is down?**
A: Orders process normally without points. When the API recovers, you can manually change order status to trigger point earning.

---

## Support

For technical support, contact JadCoins support through:
- Website: https://jadcoins.online
- Email: support@jadcoins.online
