(function($) {
    'use strict';

    $(document).ready(function() {

        // Connect & Verify
        $('#jadcoins-test-connection').on('click', function() {
            var $btn = $(this);
            var $result = $('#jadcoins-test-result');
            var $companyInfo = $('#jadcoins-company-info');

            var apiUrl = $('input[name="jadcoins_api_url"]').val();
            var companyCode = $('input[name="jadcoins_company_code"]').val();

            if (!apiUrl || !companyCode) {
                $result.text('Please fill in API URL and Company Code.').addClass('error');
                return;
            }

            $btn.prop('disabled', true);
            $result.text(jadcoins_admin.i18n.testing).removeClass('success error');

            $.ajax({
                url: jadcoins_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'jadcoins_test_connection',
                    nonce: jadcoins_admin.nonce,
                    api_url: apiUrl,
                    company_code: companyCode,
                },
                success: function(response) {
                    if (response.success) {
                        var data = response.data;
                        $result.text(jadcoins_admin.i18n.success + ' (' + data.company_name + ')').addClass('success');

                        $('#jadcoins-company-name').text('🏢 ' + data.company_name);
                        var statusText = data.loyalty_enabled ? '✅ Loyalty Enabled' : '❌ Loyalty Disabled';
                        $('#jadcoins-loyalty-status').text(statusText);

                        var details = '';
                        if (data.settings) {
                            var s = data.settings;
                            details += '<p><strong>Points Type:</strong> ' + s.points_type + '</p>';
                            if (s.points_type === 'percent') {
                                details += '<p><strong>Percentage:</strong> ' + s.percentage_points + '%</p>';
                            } else {
                                details += '<p><strong>Fixed Points:</strong> ' + s.fixed_points + '</p>';
                            }
                            details += '<p><strong>Point Value:</strong> ' + (data.currency ? data.currency.symbol : '') + s.point_value + '</p>';
                            details += '<p><strong>Min Redemption:</strong> ' + s.min_redemption_points + ' points</p>';
                        }
                        $('#jadcoins-loyalty-details').html(details);
                        $companyInfo.slideDown();

                        // Reload page after 2 seconds to show connected state
                        setTimeout(function() {
                            window.location.reload();
                        }, 2000);
                    } else {
                        $result.text(jadcoins_admin.i18n.error + ' ' + response.data).addClass('error');
                        $companyInfo.slideUp();
                    }
                },
                error: function() {
                    $result.text(jadcoins_admin.i18n.error + ' Network error').addClass('error');
                },
                complete: function() {
                    $btn.prop('disabled', false);
                }
            });
        });

        // Disconnect
        $('#jadcoins-disconnect').on('click', function() {
            if (!confirm(jadcoins_admin.i18n.confirm_disconnect)) {
                return;
            }

            var $btn = $(this);
            $btn.prop('disabled', true);

            $.ajax({
                url: jadcoins_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'jadcoins_disconnect',
                    nonce: jadcoins_admin.nonce,
                },
                success: function(response) {
                    if (response.success) {
                        alert(jadcoins_admin.i18n.disconnected);
                        window.location.reload();
                    }
                },
                complete: function() {
                    $btn.prop('disabled', false);
                }
            });
        });

    });

})(jQuery);
